// PWRPICDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PWRPIC.h"
#include "PWRPICDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


class CAboutDlg : public CDialog
{
public:
  CAboutDlg();

  // Dialog Data
  enum { IDD = IDD_ABOUTBOX };

protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  // Implementation
protected:
  DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


CPWRPICDlg::CPWRPICDlg(CWnd* pParent /*=NULL*/)
: CDialog(CPWRPICDlg::IDD, pParent)
, m_Ignition(FALSE)
{
  m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPWRPICDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_SOFTOFFVAL, m_Softoff_Edit);
  DDX_Control(pDX, IDC_SOFTSPIN, m_SoftSpin);
  DDX_Control(pDX, IDC_HARDOFFVAL, m_Hardoff_Edit);
  DDX_Control(pDX, IDC_HARDSPIN, m_HardSpin);
  DDX_Radio(pDX, IDC_IGNITION, m_Ignition);
}

BEGIN_MESSAGE_MAP(CPWRPICDlg, CDialog)
  ON_WM_SYSCOMMAND()
  ON_WM_PAINT()
  ON_WM_QUERYDRAGICON()
  ON_BN_CLICKED(IDC_APPLY, &CPWRPICDlg::OnBnClickedApply)
  ON_BN_CLICKED(IDC_DEFAULT, &CPWRPICDlg::OnBnClickedDefault)
  ON_BN_CLICKED(IDC_IGNITION, &CPWRPICDlg::OnBnClickedIgnition)
  ON_BN_CLICKED(IDC_REMOTE, &CPWRPICDlg::OnBnClickedRemote)
  ON_BN_CLICKED(IDOK, &CPWRPICDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CPWRPICDlg::OnInitDialog()
{
  CDialog::OnInitDialog();

  // Add "About..." menu item to system menu.

  // IDM_ABOUTBOX must be in the system command range.
  ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
  ASSERT(IDM_ABOUTBOX < 0xF000);

  CMenu* pSysMenu = GetSystemMenu(FALSE);

  CString CaptionString;
  if(PWRPIC_Get_Ver() && PWRPIC_Get_Ignition(&ignition) && PWRPIC_Get_Mode()) { 
    CaptionString.Format(_T("AR-B6002 <Mode %d> Setup %c.%c Ignition=%s"),
      mode, ver.majorVersion, ver.minorVersion, (ignition==IGN_ON?L"On":L"Off"));
    this->SetWindowTextW(CaptionString);
  } //show Dialog Cap

  CStatic* bObj=(CStatic*)this->GetDlgItem(IDC_BATTERY);
  if(PWRPIC_Get_Battery()) {
    CaptionString.Format(_T("Battery Voltage: %.2f"),batVol);
    bObj->SetWindowTextW(CaptionString);
  } //show battery voltage

  UDACCEL AccellValue;
  AccellValue.nSec = 1000;
  AccellValue.nInc = 5;
  m_SoftSpin.SetRange32(0, 16777215);
  m_SoftSpin.SetAccel(1, &AccellValue); 
  m_HardSpin.SetRange32(0, 16777215);
  m_HardSpin.SetAccel(1, &AccellValue); 

  if(PWRPIC_Get_Softoff())
    m_SoftSpin.SetPos32(softoff);

  if(PWRPIC_Get_Hardoff())
    m_HardSpin.SetPos32(hardoff);

  if(PWRPIC_Get_Power_Mode())
    if(power_mode==IGN_MOD) {
      m_Ignition=0;
      UpdateData(FALSE);
	} else {
      m_Ignition=1;
      UpdateData(FALSE);
	}
	
    if (pSysMenu != NULL) {
      CString strAboutMenu;
      strAboutMenu.LoadString(IDS_ABOUTBOX);
      if (!strAboutMenu.IsEmpty()) {
        pSysMenu->AppendMenu(MF_SEPARATOR);
        pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
      }
    }

    // Set the icon for this dialog.  The framework does this automatically
    //  when the application's main window is not a dialog
    SetIcon(m_hIcon, TRUE);			// Set big icon
    SetIcon(m_hIcon, FALSE);		// Set small icon

    // TODO: Add extra initialization here

    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPWRPICDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
  if ((nID & 0xFFF0) == IDM_ABOUTBOX) {
    CAboutDlg dlgAbout;
    dlgAbout.DoModal();
  } else {
    CDialog::OnSysCommand(nID, lParam);
  }
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPWRPICDlg::OnPaint()
{
  if (IsIconic()) {
    CPaintDC dc(this); // device context for painting

    SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

    // Center icon in client rectangle
    int cxIcon = GetSystemMetrics(SM_CXICON);
    int cyIcon = GetSystemMetrics(SM_CYICON);
    CRect rect;
    GetClientRect(&rect);
    int x = (rect.Width() - cxIcon + 1) / 2;
    int y = (rect.Height() - cyIcon + 1) / 2;

    // Draw the icon
    dc.DrawIcon(x, y, m_hIcon);
  } else {
    CDialog::OnPaint();
  }
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPWRPICDlg::OnQueryDragIcon()
{
  return static_cast<HCURSOR>(m_hIcon);
}

BOOL CPWRPICDlg::PWRPIC_Get_Ver()
{
	int result = -1;
	result = getPicFwVer( (PicInfo *)&ver.type[0] );
	if( result == -1 )
		return(FALSE);
	else
		return(TRUE);
}


BOOL CPWRPICDlg::PWRPIC_Get_Ignition(unsigned char *ignStatus)
{
	int result = -1;
	result = getIgnStatus(ignStatus);
	if( result == -1 )
		return(FALSE);
	else
		return(TRUE);
}

BOOL CPWRPICDlg::PWRPIC_Get_Mode()
{
	int result = -1;
	result = getPicMode(&mode);

	if( result == -1 )
		return(FALSE);
	else
		return(TRUE);
}

BOOL CPWRPICDlg::PWRPIC_Get_Battery()
{
	int result = -1;
	result = getBattVolt( &batVol );
	if( result == -1 )
		return(FALSE);
	else
		return(TRUE);
}

BOOL CPWRPICDlg::PWRPIC_Set_SoftoffS(unsigned long val)
{
  int result = -1;
  result = setSoftOffDelayS( val );

  if( result == -1 )
	  return(FALSE);
  else
	  return TRUE;
}

BOOL CPWRPICDlg::PWRPIC_Get_Softoff()
{
	int result = -1;
	result = getSoftOffDelay( &softoff );

	if( result == -1 )
		return(FALSE);
	else
		return(TRUE);
}

BOOL CPWRPICDlg::PWRPIC_Set_HardoffS(unsigned long val)
{
  int result = -1;
  result = setHardOffDelayS(val);
  if( result == -1 )
	  return(FALSE);
  else
	  return TRUE;
}

BOOL CPWRPICDlg::PWRPIC_Get_Hardoff()
{
	int result = -1;
	result = getHardOffDelay( &hardoff );
	if( result == -1 )
		return(FALSE);
	else
		return(TRUE);
}

BOOL CPWRPICDlg::PWRPIC_Set_Default()
{
	int result = -1;
	result = setPicDefault();

	if( result == -1 )
		return(FALSE);
	else
		return(TRUE);
}

BOOL CPWRPICDlg::PWRPIC_Set_Power_Mode(unsigned char val)
{
	int result = -1;
	result = setPowerOnMode( val );

	if( result == -1 )
		return(FALSE);
	else
		return(TRUE);
}

BOOL CPWRPICDlg::PWRPIC_Get_Power_Mode()
{
	int result = -1;
	result = getPowerOnMode( &power_mode );
	if( result == -1 )
		return(FALSE);
	else
		return(TRUE);
}


void CPWRPICDlg::OnBnClickedApply()
{
  PWRPIC_Set_SoftoffS((unsigned long)(m_SoftSpin.GetPos32()));
  PWRPIC_Set_HardoffS((unsigned long)(m_HardSpin.GetPos32()));
  UpdateData(TRUE);
  PWRPIC_Set_Power_Mode(m_Ignition==0?0xA5:0x5A);
}

void CPWRPICDlg::OnBnClickedDefault()
{
  // TODO: b[JiBz`{X
  PWRPIC_Set_Default();

  if(PWRPIC_Get_Softoff())
    m_SoftSpin.SetPos32(softoff);

  if(PWRPIC_Get_Hardoff())
    m_HardSpin.SetPos32(hardoff);
}
void CPWRPICDlg::OnBnClickedIgnition()
{
  // TODO: b[JiBz`{X
}

void CPWRPICDlg::OnBnClickedRemote()
{
  // TODO: b[JiBz`{X
}

void CPWRPICDlg::OnBnClickedOk()
{
  // TODO: b[JiBz`{X
  PWRPIC_Set_SoftoffS((unsigned long)(m_SoftSpin.GetPos32()));
  PWRPIC_Set_HardoffS((unsigned long)(m_HardSpin.GetPos32()));
  UpdateData(TRUE);
  PWRPIC_Set_Power_Mode(m_Ignition==0?0xA5:0x5A);
  OnOK();
}
