#include <termios.h>
#include <unistd.h> // For 'struct termios'
/*
 * The struct 'PwrDev' stores the information of the COM port
 * which is connected to the Power subsystem.
 *
 *  port: The device node name of the port to which the
 *        Power subsystem connects.
 *
 *  fd:   The file descriptor of the port after being opened.
 *
 *  portios: The 'termios' info of the COM port.
 *
 *  init: This flag will be set to 1 after the port has been
 *        initialized to the expected operating status.
 */
struct PwrDev {
  char   *port;  
  int    fd;              
  struct termios portios;
  int    init;            
};

typedef struct _PicInfo {
	unsigned char type[3];
	unsigned char mode[4];
	unsigned char majorVersion;
	unsigned char minorVersion;
} PicInfo;

#define CMD_GET_IGN_STS    0xf5
#define CMD_SET_SOFTOFF    0xf1 
#define CMD_GET_SOFTOFF    0xf2 
#define CMD_SET_HARDOFF    0xf3 
#define CMD_GET_HARDOFF    0xf4 
#define CMD_SET_PWR_MOD    0xf9
#define CMD_GET_PWR_MOD    0xfa
#define CMD_GET_BAT_VOL    0xf6
#define CMD_GET_PIC_VER    0xf0
#define CMD_GET_PIC_MOD    0xf7
#define CMD_SET_PIC_DEFAULT 0xf8

#define IGN_ON             0xa5     // Ignition is ON
#define IGN_OFF            0x5a     // Ignition is OFF.

#define IGN_MOD            0xa5     // Ignition Mode
#define RMT_SWH_MOD        0x5a     // Remote Switch Mode

#define USLEEP 1000
#define TIMES   100

/* Power Subsystem APIs */
int getIgnStatus( unsigned char *ignStatus ); // Get the current ignitions status.

int setSoftOffDelayS( unsigned long setTime);
int setHardOffDelayS( unsigned long setTime);
int setSoftOffDelayM( unsigned long setTime);
int setHardOffDelayM( unsigned long setTime);
int setPowerOnMode( unsigned char powerOnMode );

int getSoftOffDelay( unsigned long *timeDelay );
int getHardOffDelay( unsigned long *timeDelay );
int getPowerOnMode( unsigned char *powerOnMode ); // Get the setting of the mode
                                                  // of power-on in the EEPROM
int getBattVolt( unsigned char *volt );
int getPicFwVer( PicInfo *ver );

int getPicMode(unsigned char *mode);
int setPicDefault(void);
