using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace CSLibTest
{
    class Program
    {
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte nucupsOpenDeviceHandler(int timer);
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void nucupsCloseDeviceHandler();
        [DllImport("NUCUpsLib.dll", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Cdecl)]
        public static extern void getNUCUpsDevicePath(StringBuilder value);
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte isNUCUpsConnected();
        
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsVIn();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsIOut();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsVOut();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsVBats(int i);
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsTemperature(int i);
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsVIgnition();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsPOut();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsVBat();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsVPack();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCUpsIChgDchg();

        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCUpsVerMajor();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCUpsVerMinor();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCUpsState();

        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCUpsBatteryLevel();

        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCUpsMode();
        
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void restartNUCUps();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void restartNUCUpsInBootloaderMode();

        //Flash stuff
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void startNUCUpsLoadingSettings(Byte to_file, Byte compare_with_old);
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCUpsLoadingSettingsState();
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int getNUCUpsMaxVariableCnt();
        [DllImport("NUCUpsLib.dll", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCUpsVariableData(int cnt, StringBuilder name, StringBuilder value, StringBuilder unit, StringBuilder comment);
        [DllImport("NUCUpsLib.dll", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte setNUCUpsVariableData(int cnt, String value);
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void startNUCUpsSaveSettings(Byte from_file);
        [DllImport("NUCUpsLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCUpsSaveSettingsState();

        static void Main(string[] args)
        {
            Console.WriteLine("HIT <Esc> TO EXIT!");

	        int state;

	        nucupsOpenDeviceHandler(1000);
	        if (isNUCUpsConnected() == 1)
	        {
                Console.WriteLine("NUCUps opened!");
                System.Threading.Thread.Sleep(500);	//it's recommended to give a few miliseconds before the first read otherwise the first read might be 0 

		        //the library reads the NUCUps values in every 1000 msec (once per second)
		        //therefore is useless to read them faster from here

		        StringBuilder path = new StringBuilder(1024);
		        getNUCUpsDevicePath(path);
        		
		        Console.Write(" firmware: ");Console.Write(getNUCUpsVerMajor());Console.Write(".");Console.Write(getNUCUpsVerMinor());Console.WriteLine();
		        Console.Write(" path: ");Console.Write(path);Console.WriteLine();
		        Console.WriteLine("------------------------------");
	        }
	        else Console.WriteLine("NUCUps not found!");

            ConsoleKey ch = ConsoleKey.Backspace;//no matter, just not Esc

            while (ch != ConsoleKey.Escape)
	        {
		        if (Console.KeyAvailable)
		        {
			        ch = Console.ReadKey().Key;
                    if (ch != ConsoleKey.Escape)
			        {
				        Console.WriteLine("Press again:\n");
				        Console.WriteLine("L.Load flash\nQ.Set flash 1\nW.Set flash 2\nA.Save settings to file\nS.Load settings from file");
                        char readch = Console.ReadKey().KeyChar;
                        switch (readch)
				        {
				        case 'l':
				        case 'L': 
					        {
						        Console.WriteLine("Loading flash values. Wait ...");
						        startNUCUpsLoadingSettings(0,0);
						        int timeout = 0;
						        while ((getNUCUpsLoadingSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						        {
							        Console.WriteLine("Loading ");Console.Write(getNUCUpsLoadingSettingsState());Console.Write("%");
							        timeout++;
							        System.Threading.Thread.Sleep(500);
						        }
						        Console.WriteLine("Loading final: ");Console.Write(getNUCUpsLoadingSettingsState());Console.Write("%");//100=OK, F0-FF=ERRORCODE
                                if (getNUCUpsLoadingSettingsState() == 100)//succesfull
                                {
                                    int var_max = getNUCUpsMaxVariableCnt();
                                    StringBuilder name = new StringBuilder(256);
                                    StringBuilder value = new StringBuilder(256);
                                    StringBuilder unit = new StringBuilder(256);
                                    StringBuilder comment = new StringBuilder(1024);

                                    for (int i = 0; i < var_max; i++)
                                        if (getNUCUpsVariableData(i, name, value, unit, comment) != 0)
                                        {
                                            Console.Write("[");
                                            Console.Write(i);
                                            Console.Write("] ");
                                            Console.Write(name.ToString());
                                            Console.Write("=");
                                            Console.Write(value.ToString());
                                            Console.Write(" ");
                                            Console.Write(unit.ToString());
                                            Console.WriteLine();
                                        }
                                }
                                else
                                {
                                    Console.WriteLine("    ERROR: ");
                                    Console.Write(getNUCUpsLoadingSettingsState());
                                }
					        }break;
				        case 'a':
				        case 'A':
					        {
						        Console.WriteLine("Saving flash values to file. Wait ...");
						        startNUCUpsLoadingSettings(1,0);
						        int timeout = 0;
						        while ((getNUCUpsLoadingSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						        {
							        Console.WriteLine("Loading ");Console.Write(getNUCUpsLoadingSettingsState());Console.Write("%");
							        timeout++;
							        System.Threading.Thread.Sleep(500);
						        }
						        Console.WriteLine("Loading final: ");Console.Write(getNUCUpsLoadingSettingsState());Console.Write("%");//100=OK, F0-FF=ERRORCODE
					        }break;
				        case 's':
				        case 'S':
					        {
						        Console.WriteLine("Loading flash values from file. Wait ...");
						        startNUCUpsSaveSettings(1);
						        int timeout = 0;
						        while ((getNUCUpsSaveSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						        {
                                    Console.WriteLine("Saving "); Console.Write(getNUCUpsSaveSettingsState()); Console.Write("%");
							        timeout++;
							        System.Threading.Thread.Sleep(500);
						        }
						        Console.WriteLine("Saving final: ");Console.Write(getNUCUpsSaveSettingsState());Console.Write("%");//100=OK, F0-FF=ERRORCODE
					        }break;
                        case 'q':
                        case 'Q':
                        case 'w':
                        case 'W':
                            {
                                if ((readch == 'q') || (readch == 'Q'))
                                {
                                    setNUCUpsVariableData(48, "3111");//POUT_HIGH_THRESHOLD
                                    setNUCUpsVariableData(20, "11111111");//CONFIG2
                                }
                                else
                                {
                                    setNUCUpsVariableData(48, "3000");//POUT_HIGH_THRESHOLD
                                    setNUCUpsVariableData(20, "00000000");//CONFIG2
                                }

                                startNUCUpsSaveSettings(0);
                                int timeout = 0;
                                while ((getNUCUpsSaveSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
                                {
                                    Console.WriteLine("Saving ");Console.Write(getNUCUpsSaveSettingsState());Console.Write("%");
                                    timeout++;
                                    System.Threading.Thread.Sleep(500);
                                }
                                Console.WriteLine("Saving final: ");Console.Write(getNUCUpsSaveSettingsState());Console.Write("%");//100=OK, F0-FF=ERRORCODE
                            } break;
				        }
			        }
		        }
		        else
		        {
			        if (isNUCUpsConnected() == 0)
			        {
				        //nucupsCloseDeviceHandler();//close it only if you do not want auto reconnect
				        Console.WriteLine("No device");
			        }
			        else
			        {
                        Console.Write("Mode="); Console.Write(getNUCUpsMode());
                        Console.Write(" VIn="); Console.Write(getNUCUpsVIn());
                        Console.Write(" VIgn="); Console.Write(getNUCUpsVIgnition());
                        Console.Write(" VBat="); Console.Write(getNUCUpsVBat());
                        Console.Write(" VOut="); Console.Write(getNUCUpsVOut());
                        Console.Write(" POut="); Console.Write(getNUCUpsPOut());
                        Console.Write(" IOut="); Console.Write(getNUCUpsIOut());
                        Console.Write(" Capacity="); Console.Write(getNUCUpsBatteryLevel());
                        Console.Write(" Ichg="); Console.Write(getNUCUpsIChgDchg());
                        Console.WriteLine();
                        Console.Write("    Cells=");
                        for (int i = 0; i < 4; i++)
                        {
                            Console.Write("[");
                            Console.Write(i);
                            Console.Write(" ");
                            Console.Write(getNUCUpsVBats(i));
                            Console.Write("V ");
                            Console.Write(getNUCUpsTemperature(i));
                            Console.Write("C] ");
                        }
                        Console.WriteLine();
			        }
			        System.Threading.Thread.Sleep(1000);
		        }
	        }//while
            
	        nucupsCloseDeviceHandler();
        }
    }
}
